/*

TimeMonitor.js

methods::

setLength(int:length)
Specify the length of the TimeMonitor in ms

start();
starts the TimeMonitor

pause();
pause the Monitor, call start() to continue

stop();
stops the Monitor, call start() to restart

getPercent(); :float
retrives the current average of the Monitor





/***************************************/

function TimeMonitor(l){

	this.length=((l==undefined)?100:l);
	this.percent = 0;
	this.running = false;
	this.startTime = 0;
	this.pauseTime = 0;
	this.isReset = false;
}

TimeMonitor.prototype.setLength = function(l){
	
	if(!this.running)this.length = l;

}


TimeMonitor.prototype.start = function(){

	with (this){
		
		running=true;
		startTime = GetTime() + pauseTime;
		pauseTime = 0;
		isReset = false;
	}
	
}



TimeMonitor.prototype.pause = function(){
	
	with (this){
		if(running){
			pauseTime=GetTime()-startTime;
			}
	}

}

TimeMonitor.prototype.stop = function(){
	
	with (this){
		if(running){
			running=false;
			isReset = true;
			}
	}

}

TimeMonitor.prototype.getPercent = function(){
	
	with(this){
		
		if(running){
				var t=((GetTime()-startTime)/length)*100;
				if(t>=100){
					running=false;
					t=100;
					}
				return t;
			}
		
		if(isReset)return 0;
		return t;
			
	}
	

}

TimeMonitor.prototype.isRunning = function(){
	
	return this.running;

}
